//+-------------------------------------------------------------------------+ 
//|                                                      LaguerreVolume.mq5 | 
//|                                 Copyright  2007, Emerald King, t_david |
//| http://finance.groups.yahoo.com/group/MetaTrader_Experts_and_Indicators |
//+-------------------------------------------------------------------------+
#property copyright "Copyright  2007, Emerald King, t_david"
#property link      "http://finance.groups.yahoo.com/group/MetaTrader_Experts_and_Indicators"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DarkOrchid 
#property indicator_color1 clrDarkOrchid
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1 1
//----   
#property indicator_label1  "LaguerreVolume"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET  0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input double gamma=0.618;                          //  
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  // 
input int Shift=0;                                 //      
input double inHighLevel=0.75;
input double inMiddleLevel=0.50;
input double inLowLevel=0.25;
//+-----------------------------------+
//----  
double IndBuffer[];
//----   
int min_rates_total;
//+------------------------------------------------------------------+    
//| LaguerreVolume indicator initialization function                 | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=2;
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"LaguerreVolume",DoubleToString(gamma,3),")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----      3   
   IndicatorSetInteger(INDICATOR_LEVELS,3);
//----       
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,inHighLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,inMiddleLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,inLowLevel);
//----             
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrRed);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrBlue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,clrGray);
//----       -  
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,STYLE_DASHDOTDOT);
//----  
  }
//+------------------------------------------------------------------+  
//| LaguerreVolume iteration function                                | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----    
   long vol;
   int limit,bar;
   double L0,L1,L2,L3,L0A,L1A,L2A,L3A,CD,CU,RES;
//----        
   static double L0_,L1_,L2_,L3_,L0A_,L1A_,L2A_,L3A_;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      //----    
      double Vol;
      if(VolumeType==VOLUME_TICK) Vol=double(tick_volume[0]);
      else                        Vol=double(volume[0]);
      L0_ = Vol;
      L1_ = Vol;
      L2_ = Vol;
      L3_ = Vol;
      L0A_ = Vol;
      L1A_ = Vol;
      L2A_ = Vol;
      L3A_ = Vol;
     }
   else limit=rates_total-prev_calculated; //      
//----   
   L0 = L0_;
   L1 = L1_;
   L2 = L2_;
   L3 = L3_;
   L0A = L0A_;
   L1A = L1A_;
   L2A = L2A_;
   L3A = L3A_;
//----         
   if(VolumeType==VOLUME_TICK) ArraySetAsSeries(tick_volume,true);
   else                        ArraySetAsSeries(volume,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      L0A = L0;
      L1A = L1;
      L2A = L2;
      L3A = L3;
      //----
      if(VolumeType==VOLUME_TICK) vol=tick_volume[bar];
      else                        vol=volume[bar];
      //----
      L0 = (1 - gamma) * vol + gamma * L0A;
      L1 = - gamma * L0 + L0A + gamma * L1A;
      L2 = - gamma * L1 + L1A + gamma * L2A;
      L3 = - gamma * L2 + L2A + gamma * L3A;
      //----
      CU = 0;
      CD = 0;
      //---- 
      if(L0 >= L1) CU  = L0 - L1; else CD  = L1 - L0;
      if(L1 >= L2) CU += L1 - L2; else CD += L2 - L1;
      if(L2 >= L3) CU += L2 - L3; else CD += L3 - L2;
      //----
      RES=CU+CD;
      if(RES) IndBuffer[bar]=CU/RES;
      else IndBuffer[bar]=0.0;
      //----        
      if(bar)
        {
         L0_ = L0;
         L1_ = L1;
         L2_ = L2;
         L3_ = L3;
         L0A_ = L0A;
         L1A_ = L1A;
         L2A_ = L2A;
         L3A_ = L3A;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
