//+------------------------------------------------------------------+ 
//|                            Background_MA_Rounding_Candle_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.60"
#property description " MA_Rounding        ."
//---     
#property indicator_chart_window
//---    12
#property indicator_buffers 12 
//---    
#property indicator_plots   6
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                        //        
#define INDICATOR_NAME "Background_MA_Rounding_Candle" //    
#define SIZE  1                                        //      CountIndicator  
#define EMPTYVALUE 0                                   //     
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1  clrSkyBlue,clrPlum
//---   -  
#property indicator_style1  STYLE_SOLID
//---   
#property indicator_label1  "Upper Shade"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---      
#property indicator_type2   DRAW_FILLING
//---     
#property indicator_color2  clrDeepSkyBlue,clrOrchid
//---   -  
#property indicator_style2  STYLE_SOLID
//---   
#property indicator_label2  "Body"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//---      
#property indicator_type3   DRAW_FILLING
//---     
#property indicator_color3  clrSkyBlue,clrPlum
//---   -  
#property indicator_style3  STYLE_SOLID
//---   
#property indicator_label3  "Lower Shade"
//+----------------------------------------------+
//|    4             |
//+----------------------------------------------+
//---      
#property indicator_type4   DRAW_FILLING
//---     
#property indicator_color4  clrSkyBlue,clrPlum
//---   -  
#property indicator_style4  STYLE_SOLID
//---   
#property indicator_label4  "Upper Shade"
//+----------------------------------------------+
//|    5             |
//+----------------------------------------------+
//---      
#property indicator_type5   DRAW_FILLING
//---     
#property indicator_color5  clrDeepSkyBlue,clrOrchid
//---   -  
#property indicator_style5  STYLE_SOLID
//---   
#property indicator_label5  "Body"
//+----------------------------------------------+
//|    6             |
//+----------------------------------------------+
//---      
#property indicator_type6   DRAW_FILLING
//---     
#property indicator_color6  clrSkyBlue,clrPlum
//---   -  
#property indicator_style6  STYLE_SOLID
//---   
#property indicator_label6  "Lower Shade"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;//   
input Smooth_Method XMA_Method=MODE_SMA;  //  
input int XLength=12; //  
input int XPhase=15;  //  
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input uint MaRound=50; //   
input int    Shift=0;  //      
//+----------------------------------------------+
//---   ,   
//---      
double ExtA1Buffer[];
double ExtB1Buffer[];
double ExtA2Buffer[];
double ExtB2Buffer[];
double ExtA3Buffer[];
double ExtB3Buffer[];
double ExtA4Buffer[];
double ExtB4Buffer[];
double ExtA5Buffer[];
double ExtB5Buffer[];
double ExtA6Buffer[];
double ExtB6Buffer[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---    MA_Rounding_Candle
   Ind_Handle=iCustom(Symbol(),TimeFrame,"MA_Rounding_Candle",XMA_Method,XLength,XPhase,MaRound);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      MA_Rounding_Candle");
      return(INIT_FAILED);
     }
//---   
   min_rates_total=2;
//---      
   ArrayInit(0,ExtA1Buffer);
   ArrayInit(1,ExtB1Buffer);
   ArrayInit(2,ExtA2Buffer);
   ArrayInit(3,ExtB2Buffer);
   ArrayInit(4,ExtA3Buffer);
   ArrayInit(5,ExtB3Buffer);
   ArrayInit(6,ExtA4Buffer);
   ArrayInit(7,ExtB4Buffer);
   ArrayInit(8,ExtA5Buffer);
   ArrayInit(9,ExtB5Buffer);
   ArrayInit(10,ExtA6Buffer);
   ArrayInit(11,ExtB6Buffer);
//---  
   PlotInit(0,2,Shift);
   PlotInit(1,2,Shift);
   PlotInit(2,2,Shift);
   PlotInit(3,2,Shift);
   PlotInit(4,2,Shift);
   PlotInit(5,2,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",EnumToString(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,Symbol(),TimeFrame,Ind_Handle,
      ExtA1Buffer,ExtB1Buffer,ExtA2Buffer,ExtB2Buffer,
      ExtA3Buffer,ExtB3Buffer,ExtA4Buffer,ExtB4Buffer,
      ExtA5Buffer,ExtB5Buffer,ExtA6Buffer,ExtB6Buffer,
      time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountIndicator                                                   |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,             //   CountLine      (  - 0)
                    string   Symb,             //  
                    ENUM_TIMEFRAMES TFrame,    //  
                    int      IndHandle,        //   
                    double&  ExtA1Buff[],      //    1
                    double&  ExtB1Buff[],      //    2
                    double&  ExtA2Buff[],      //    3
                    double&  ExtB2Buff[],      //    4
                    double&  ExtA3Buff[],      //    5
                    double&  ExtB3Buff[],      //    6
                    double&  ExtA4Buff[],      //    7
                    double&  ExtB4Buff[],      //    8
                    double&  ExtA5Buff[],      //    9
                    double&  ExtB5Buff[],      //    10
                    double&  ExtA6Buff[],      //    11
                    double&  ExtB6Buff[],      //    11
                    const datetime &Time[],    //  
                    const int Rates_Total,     //       
                    const int Prev_Calculated, //       
                    const int Min_Rates_Total) //       
  {
//---
   static int Sign;
   static datetime LastTime;
   static int LastCountBar[SIZE];
   double iOpen[1],iLow[1],iHigh[1],iClose[1];
   datetime iTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
      LastTime=0;
      Sign=1;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,Time[bar],1,iTime)<=0) return(RESET);
      //---
      if(Time[bar]>=iTime[0] && Time[bar+1]<iTime[0])
        {
         LastCountBar[Numb]=bar;
         if(iTime[0]!=LastTime)
           {
            LastTime=iTime[0];
            Sign*=(-1);
           }
         //---      
         if(CopyBuffer(IndHandle,0,Time[bar],1,iOpen)<=0) return(RESET);
         if(CopyBuffer(IndHandle,1,Time[bar],1,iHigh)<=0) return(RESET);
         if(CopyBuffer(IndHandle,2,Time[bar],1,iLow)<=0) return(RESET);
         if(CopyBuffer(IndHandle,3,Time[bar],1,iClose)<=0) return(RESET);
         //---
         if(Sign>0)
           {
            if(iClose[0]>=iOpen[0])
              {
               ExtA1Buff[bar]=iHigh[0];
               ExtB1Buff[bar]=iClose[0];
               ExtA2Buff[bar]=iClose[0];
               ExtB2Buff[bar]=iOpen[0];
               ExtA3Buff[bar]=iOpen[0];
               ExtB3Buff[bar]=iLow[0];
              }
            else
              {
               ExtB1Buff[bar]=iHigh[0];
               ExtA1Buff[bar]=iClose[0];
               ExtA2Buff[bar]=iClose[0];
               ExtB2Buff[bar]=iOpen[0];
               ExtB3Buff[bar]=iOpen[0];
               ExtA3Buff[bar]=iLow[0];
              }
            //---
            ExtA4Buff[bar]=EMPTYVALUE;
            ExtB4Buff[bar]=EMPTYVALUE;
            ExtA5Buff[bar]=EMPTYVALUE;
            ExtB5Buff[bar]=EMPTYVALUE;
            ExtA6Buff[bar]=EMPTYVALUE;
            ExtB6Buff[bar]=EMPTYVALUE;
           }
         else
           {
            if(iClose[0]>=iOpen[0])
              {
               ExtA4Buff[bar]=iHigh[0];
               ExtB4Buff[bar]=iClose[0];
               ExtA5Buff[bar]=iClose[0];
               ExtB5Buff[bar]=iOpen[0];
               ExtA6Buff[bar]=iOpen[0];
               ExtB6Buff[bar]=iLow[0];
              }
            else
              {
               ExtB4Buff[bar]=iHigh[0];
               ExtA4Buff[bar]=iClose[0];
               ExtA5Buff[bar]=iClose[0];
               ExtB5Buff[bar]=iOpen[0];
               ExtB6Buff[bar]=iOpen[0];
               ExtA6Buff[bar]=iLow[0];
              }
            ExtA1Buff[bar]=EMPTYVALUE;
            ExtB1Buff[bar]=EMPTYVALUE;
            ExtA2Buff[bar]=EMPTYVALUE;
            ExtB2Buff[bar]=EMPTYVALUE;
            ExtA3Buff[bar]=EMPTYVALUE;
            ExtB3Buff[bar]=EMPTYVALUE;
           }
        }
      else
        {
         ExtA1Buff[bar]=ExtA1Buff[bar+1];
         ExtB1Buff[bar]=ExtB1Buff[bar+1];
         ExtA2Buff[bar]=ExtA2Buff[bar+1];
         ExtB2Buff[bar]=ExtB2Buff[bar+1];
         ExtA3Buff[bar]=ExtA3Buff[bar+1];
         ExtB3Buff[bar]=ExtB3Buff[bar+1];
         ExtA4Buff[bar]=ExtA4Buff[bar+1];
         ExtB4Buff[bar]=ExtB4Buff[bar+1];
         ExtA5Buff[bar]=ExtA5Buff[bar+1];
         ExtB5Buff[bar]=ExtB5Buff[bar+1];
         ExtA6Buff[bar]=ExtA6Buff[bar+1];
         ExtB6Buff[bar]=ExtB6Buff[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| PlotInit()                                                       |
//+------------------------------------------------------------------+    
void PlotInit(uint PlotNumber,
              int DrawBegin,
              int PlotShift)
  {
//---      
   PlotIndexSetInteger(PlotNumber,PLOT_DRAW_BEGIN,DrawBegin);
//---    1    Shift
   PlotIndexSetInteger(PlotNumber,PLOT_SHIFT,PlotShift);
  }
//+------------------------------------------------------------------+
//| ArrayInit()                                                      |
//+------------------------------------------------------------------+    
void ArrayInit(uint ArrNumber,
               double &Array[])
  {
//---      
   SetIndexBuffer(ArrNumber,Array,INDICATOR_DATA);
//---       
   ArraySetAsSeries(Array,true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //   1 ( )
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
