//+------------------------------------------------------------------+
//|                                              Didi_Index_Sign.mq5 |
//|                              Copyright  2016, Rudinei Felipetto |
//|                                         http://www.conttinua.com |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2016, Rudinei Felipetto"
//---    
#property link      "http://www.conttinua.com"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrMagenta
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "Didi_Index Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrLime
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "Didi_Index Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint      Curta=3;
input uint      Longa=20;
input ENUM_MA_METHOD MA_Method=MODE_SMA; //   
input ENUM_APPLIED_PRICE MA_Price=PRICE_CLOSE;//  
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
//---
int K,C_Handle,L_Handle,ATR_Handle,min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   int ATR_Period=15;
   min_rates_total=int(MathMax(Curta,Longa));
   min_rates_total=MathMax(min_rates_total,ATR_Period)+1;
//---    iMA Curta
   C_Handle=iMA(NULL,0,Curta,0,MA_Method,MA_Price);
   if(C_Handle==INVALID_HANDLE)
     {
      Print("      iMA Curta");
      return(INIT_FAILED);
     }
//---    iMA Longa
   L_Handle=iMA(NULL,0,Longa,0,MA_Method,MA_Price);
   if(L_Handle==INVALID_HANDLE)
     {
      Print("      iMA Longa");
      return(INIT_FAILED);
     }
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,170);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,170);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="Didi_Index_Sig";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---   
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total
      || BarsCalculated(C_Handle)<rates_total
      || BarsCalculated(L_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//---    
   int to_copy,limit,bar;
   double trend,Cur[],Lon[],ATR[];
   static double prev_trend;
//---      
//---   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total; //      
      prev_trend=0;
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//---      
   if(CopyBuffer(C_Handle,0,0,to_copy,Cur)<=0) return(RESET);
   if(CopyBuffer(L_Handle,0,0,to_copy,Lon)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---         
   ArraySetAsSeries(Cur,true);
   ArraySetAsSeries(Lon,true);
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      trend=Cur[bar]-Lon[bar];
      if(!trend) trend=prev_trend;
      //---
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(prev_trend<0 && trend>0) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(prev_trend>0 && trend<0) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
      //---
      if(bar) prev_trend=trend;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
